within TestLibrary.Containers.Container1.SubContainer2;

class Unit3 "Unit3"
	replaceable TestLibrary.Models.ModelContainer1.Model1.SubModel5 sm51;
	replaceable TestLibrary.Models.ModelContainer1.Model1.SubModel5 sm52;

	replaceable TestLibrary.Models.ModelContainer1.Model1.SubModel2 sm2;
	replaceable TestLibrary.Models.ModelContainer1.Model1.SubModel3 sm3;
	replaceable TestLibrary.Models.ModelContainer1.Model1.SubModel4 sm4;

	parameter Real p1 = 10000 "p1";

	Real var1[sm2.States];
	Real var2;

encapsulated type States = enumeration(
	S1 "S1",
	X1 "X1",
	S2 "S2");

equation
	var2 = p1/(-sm52.Q);
	for i in sm2.States loop
		var1[i] = sm51.Q*sm51.states[i] + sm52.Q*sm52.states[i] + p1*sm2.rate[i];
		der(sm2.states[i]) = var1[i]/p1;
	end for;

	sm3.states = sm2.states;
	sm4.states = sm2.states;

	sm52.Q = -sm51.Q;

	sm52.states = sm2.states;
	sm52.composites = sm3.composites;
	sm52.species = sm4.species;

end Unit3;
